package com.atlassian.jira.event.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.status.Status;

import java.util.Objects;

/**
 * Published when issue status is successfully edited.
 */
@Internal
public class StatusEditedEvent extends AbstractEvent {
    private final Status originalStatus;
    private final Status updatedStatus;

    public StatusEditedEvent(Status originalStatus, Status updatedStatus) {
        super();
        this.originalStatus = originalStatus;
        this.updatedStatus = updatedStatus;
    }

    public Status getOriginalStatus() {
        return originalStatus;
    }

    public Status getUpdatedStatus() {
        return updatedStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }

        StatusEditedEvent that = (StatusEditedEvent) o;
        return Objects.equals(originalStatus, that.originalStatus) &&
                Objects.equals(updatedStatus, that.updatedStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), originalStatus, updatedStatus);
    }

    @Override
    public String toString() {
        return "StatusEditedEvent{" +
                "originalStatus=" + originalStatus +
                "updatedStatus=" + updatedStatus +
                '}';
    }
}
