package com.atlassian.jira.event.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.issue.priority.Priority;

import java.util.Objects;

/**
 * Published when issue priority is successfully moved in sequence of prioritites.
 */
@Internal
public class PriorityMovedEvent extends AbstractEvent {
    private final Priority priority;
    private final Long from;
    private final Long to;

    public PriorityMovedEvent(Priority priority, Long from, Long to) {
        super();
        this.priority = priority;
        this.from = from;
        this.to = to;
    }

    public Priority getPriority() {
        return priority;
    }

    public Long getFrom() {
        return from;
    }

    public Long getTo() {
        return to;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PriorityMovedEvent that = (PriorityMovedEvent) o;
        return Objects.equals(priority, that.priority) &&
                Objects.equals(from, that.from) &&
                Objects.equals(to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), priority, from, to);
    }

    @Override
    public String toString() {
        return "PriorityMovedEvent{" +
                "priority=" + priority +
                ", from=" + from +
                ", to=" + to +
                '}';
    }
}
