package com.atlassian.jira.event.config;

import com.atlassian.jira.issue.issuetype.IssueType;

/**
 * Abstract event that captures the data relevant to issue type events
 *
 * @since v5.1
 */
public class AbstractIssueTypeEvent {
    private IssueType issueType;
    private String issueTypeStyle;

    public AbstractIssueTypeEvent(IssueType issueType, String issueTypeStyle) {
        if (null != issueType) {
            this.issueTypeStyle = issueTypeStyle;
            this.issueType = issueType;
        }
    }

    public String getId() {
        return issueType.getId();
    }

    public IssueType getIssueType() {
        return issueType;
    }

    public String getIssueTypeStyle() {
        return issueTypeStyle;
    }
}
