package com.atlassian.jira.event.cluster;

import com.atlassian.annotations.PublicApi;

/**
 * Send when replication to node is stopped. Potential split brain may occur.
 *
 * @since v7.2.12
 */
@PublicApi
public class CacheReplicationStoppedEvent  {
    private final String nodeId;

    public CacheReplicationStoppedEvent(final String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return nodeId;
    }
}
