package com.atlassian.jira.bc.project.component;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

@PublicApi
public interface ProjectComponentService {
    /**
     * Create a project component and use default assignee type (project default).
     *
     * @return A newly created project component {@link ProjectComponent}
     * @deprecated since 6.3, use {@link #create(com.atlassian.crowd.embedded.api.User, com.atlassian.jira.util.ErrorCollection, String, String, String, Long, Long)} instead
     */
    @Deprecated
    ProjectComponent create(ApplicationUser user, ErrorCollection errorCollection, String name, String description, String lead, Long projectId);

    /**
     * Create a project component with assignee type set as provided.
     *
     * @return A newly created project component {@link ProjectComponent}
     */
    ProjectComponent create(ApplicationUser user, ErrorCollection errorCollection, String name, String description, String lead, Long projectId, Long assigneeType);

    ProjectComponent find(ApplicationUser user, ErrorCollection errorCollection, Long id);

    Collection<ProjectComponent> findAllForProject(ErrorCollection errorCollection, Long projectId);

    ProjectComponent update(ApplicationUser user, ErrorCollection errorCollection, MutableProjectComponent component);

    void deleteComponentForIssues(JiraServiceContext context, Long componentId);

    void deleteAndSwapComponentForIssues(JiraServiceContext context, Long componentId, Long swapComponentId);

    /**
     * Returns components whose names start with or fully match given substring.
     * Components that the calling user has no permissions to see or archived components are filtered out.
     *
     * @param user       the calling user
     * @param substring  the string that component names will be matched with
     * @param projectIds the list of project ids to filter components
     * @since 9.2
     */
    @ExperimentalApi
    Stream<ProjectComponent> findComponents(@Nullable ApplicationUser user, @Nonnull String substring, @Nonnull List<Long> projectIds);
}
