/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.mail.template;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.event.mail.template.BaseEmailTemplatesEvent;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Objects;
import javax.annotation.Nullable;

@EventName(value="jira.administration.email.templates.validated")
public class EmailTemplatesValidatedEvent
extends BaseEmailTemplatesEvent {
    @Nullable
    private final ValidationFailureReason reason;

    public EmailTemplatesValidatedEvent(ApplicationUser user) {
        super(user, true);
        this.reason = null;
    }

    public EmailTemplatesValidatedEvent(ApplicationUser user, ValidationFailureReason reason) {
        super(user, false);
        this.reason = Objects.requireNonNull(reason);
    }

    @Nullable
    public ValidationFailureReason getValidationFailureReason() {
        return this.reason;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmailTemplatesValidatedEvent that = (EmailTemplatesValidatedEvent)o;
        return this.reason == that.reason;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.reason});
    }

    public static enum ValidationFailureReason {
        MISSING_FILES,
        SYNTAX_ERROR,
        SENDING_ERROR;

    }
}

