/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.event.AbstractEvent;
import java.util.Optional;

public class ExportEvent
extends AbstractEvent {
    private final String key;
    private final String delimiter;
    private final String jqlString;
    private final Long issuesTotal;
    private final boolean triggeredByApplication;

    public ExportEvent(String key) {
        this(key, "");
    }

    public ExportEvent(String key, String delimiter) {
        this(key, delimiter, null, null, false);
    }

    private ExportEvent(String key, String delimiter, String jqlString, Long issuesTotal, boolean triggeredByApplication) {
        this.key = key;
        this.delimiter = delimiter;
        this.jqlString = jqlString;
        this.issuesTotal = issuesTotal;
        this.triggeredByApplication = triggeredByApplication;
    }

    public String getKey() {
        return this.key;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public Optional<String> getJqlString() {
        return Optional.ofNullable(this.jqlString);
    }

    public Optional<Long> getIssuesTotal() {
        return Optional.ofNullable(this.issuesTotal);
    }

    public boolean isTriggeredByApplication() {
        return this.triggeredByApplication;
    }

    @EventName
    public String calculateEventName() {
        return "jira.export." + this.getKey();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String ALL_FIELDS_KEY = "searchrequest-csv-all-fields";
        private static final String CURRENT_FIELDS_KEY = "searchrequest-csv-current-fields";
        private String key;
        private String delimiter;
        private String jqlString = null;
        private Long issuesTotal = null;
        private boolean triggeredByApplication = false;

        private Builder() {
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder withJqlString(String jqlString) {
            this.jqlString = jqlString;
            return this;
        }

        public Builder withIssuesTotal(long issuesTotal) {
            this.issuesTotal = issuesTotal;
            return this;
        }

        public Builder withTriggeredByApplication(boolean triggeredByApplication) {
            this.triggeredByApplication = triggeredByApplication;
            return this;
        }

        public ExportEvent build() {
            if (this.key == null) {
                throw new IllegalArgumentException("Key can not be null.");
            }
            String finalDelimiter = this.isDelimiter() ? this.delimiter : "";
            return new ExportEvent(this.key, finalDelimiter, this.jqlString, this.issuesTotal, this.triggeredByApplication);
        }

        private boolean isDelimiter() {
            return this.delimiter != null && (this.key.equals(ALL_FIELDS_KEY) || this.key.equals(CURRENT_FIELDS_KEY));
        }
    }
}

