/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.context.AbstractJiraContext;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;

@PublicApi
public class ProjectContext
extends AbstractJiraContext {
    protected Long projectCategory;
    protected Long projectId;
    private final ProjectManager projectManager;

    public ProjectContext(Long projectId) {
        this(projectId, ComponentAccessor.getProjectManager());
    }

    public ProjectContext(Long projectId, JiraContextTreeManager treeManager) {
        this.projectId = projectId;
        this.projectManager = treeManager == null ? ComponentAccessor.getProjectManager() : treeManager.getProjectManager();
    }

    public ProjectContext(Long projectId, ProjectManager projectManager) {
        this.projectId = projectId;
        this.projectManager = projectManager;
    }

    public ProjectContext(Project project, JiraContextTreeManager treeManager) {
        this(project != null ? project.getId() : null, treeManager);
    }

    public ProjectContext(IssueContext issueContext, JiraContextTreeManager treeManager) {
        this(issueContext.getProjectId(), treeManager);
    }

    @Override
    public JiraContextNode getParent() {
        return GlobalIssueContext.getInstance();
    }

    @Override
    public boolean hasParentContext() {
        return true;
    }

    @Override
    public Map<String, Object> appendToParamsMap(Map<String, Object> input) {
        return MapBuilder.newBuilder(input).add("project", this.projectId).toMap();
    }

    @Override
    public Project getProjectObject() {
        if (this.projectId == null) {
            return null;
        }
        return this.projectManager.getProjectObj(this.projectId);
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public IssueType getIssueTypeObject() {
        return null;
    }

    @Override
    public IssueType getIssueType() {
        return null;
    }

    @Override
    public String getIssueTypeId() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof JiraContextNode)) {
            return false;
        }
        JiraContextNode jiraContextNode = (JiraContextNode)o;
        return !(this.projectId != null ? !this.projectId.equals(jiraContextNode.getProjectId()) : jiraContextNode.getProjectId() != null);
    }

    @Override
    public int hashCode() {
        return 59 * (this.projectId != null ? this.projectId.hashCode() : 0) + 397;
    }

    @Override
    public String toString() {
        return "ProjectContext[projectCategoryId=" + this.projectCategory + ",projectId=" + this.projectId + ']';
    }
}

