/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public abstract class AbstractTerminologyEvent {
    protected final String originalName;
    protected final String newName;
    protected final String newNamePlural;
    protected final String oldName;
    protected final String oldNamePlural;

    public AbstractTerminologyEvent(String originalName, String newName, String newNamePlural, String oldName, String oldNamePlural) {
        this.originalName = originalName;
        this.newName = newName;
        this.newNamePlural = newNamePlural;
        this.oldName = oldName;
        this.oldNamePlural = oldNamePlural;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewNamePlural() {
        return this.newNamePlural;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getOldNamePlural() {
        return this.oldNamePlural;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{originalName='" + this.originalName + '\'' + ", newName='" + this.newName + '\'' + ", newNamePlural='" + this.newNamePlural + '\'' + ", oldName='" + this.oldName + '\'' + ", oldNamePlural='" + this.oldNamePlural + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTerminologyEvent that = (AbstractTerminologyEvent)o;
        return Objects.equals(this.originalName, that.originalName) && Objects.equals(this.newName, that.newName) && Objects.equals(this.newNamePlural, that.newNamePlural) && Objects.equals(this.oldName, that.oldName) && Objects.equals(this.oldNamePlural, that.oldNamePlural);
    }

    public int hashCode() {
        return Objects.hash(this.originalName, this.newName, this.newNamePlural, this.oldName, this.oldNamePlural);
    }
}

