/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.external.beans;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalCustomFieldValue;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.issue.label.Label;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalIssueImpl
implements ExternalIssue {
    private static final Logger log = LoggerFactory.getLogger(ExternalIssueImpl.class);
    private String oldId;
    private String id;
    private String key;
    private String summary;
    private String reporter;
    private String assignee;
    private String description;
    private String environment;
    private String project;
    private String issueType;
    private String status;
    private String priority;
    private String resolution;
    private String securityLevel;
    private Date created;
    private Date updated;
    private Date resolutionDate;
    private Date duedate;
    private Long votes;
    private Long watches;
    private Long originalEstimate;
    private Long timeSpent;
    private Long estimate;
    private final String creator;
    private ExternalProject externalProject;
    private List<String> affectedVersions;
    private List<String> fixedVersions;
    private List<String> externalComponents;
    private List<ExternalComment> externalComments;
    private List<ExternalCustomFieldValue> externalCustomFieldValues;
    private Set<Label> labels;

    public ExternalIssueImpl(@Nullable String creator) {
        this.creator = creator;
    }

    @Override
    public void setLabels(Set<Label> labels) {
        this.labels = labels;
    }

    @Override
    public Set<Label> getLabels() {
        return this.labels;
    }

    @Override
    public String getOldId() {
        return this.oldId;
    }

    @Override
    public void setOldId(String oldId) {
        this.oldId = oldId;
    }

    @Override
    public ExternalProject getExternalProject() {
        return this.externalProject;
    }

    @Override
    public void setExternalProject(ExternalProject externalProject) {
        this.externalProject = externalProject;
    }

    @Override
    public List<String> getAffectedVersions() {
        return this.affectedVersions;
    }

    @Override
    public void setAffectedVersions(List<String> affectedVersions) {
        this.affectedVersions = affectedVersions;
    }

    @Override
    public List<String> getFixedVersions() {
        return this.fixedVersions;
    }

    @Override
    public void setFixedVersions(List<String> fixedVersions) {
        this.fixedVersions = fixedVersions;
    }

    @Override
    public List<String> getExternalComponents() {
        return this.externalComponents;
    }

    @Override
    public void setExternalComponents(List<String> externalComponents) {
        this.externalComponents = externalComponents;
    }

    @Override
    public List<ExternalComment> getExternalComments() {
        return this.externalComments;
    }

    @Override
    public void setExternalComments(List<ExternalComment> externalComments) {
        this.externalComments = externalComments;
    }

    @Override
    public List<ExternalCustomFieldValue> getExternalCustomFieldValues() {
        return this.externalCustomFieldValues;
    }

    @Override
    public void setExternalCustomFieldValues(List<ExternalCustomFieldValue> externalCustomFieldValues) {
        this.externalCustomFieldValues = externalCustomFieldValues;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getReporter() {
        return this.reporter;
    }

    @Override
    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    @Override
    public void setProject(String project) {
        this.project = project;
    }

    @Override
    public String getIssueType() {
        return this.issueType;
    }

    @Override
    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(String priority) {
        this.priority = priority;
    }

    @Override
    public String getResolution() {
        return this.resolution;
    }

    @Override
    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Override
    public Date getResolutionDate() {
        return this.resolutionDate;
    }

    @Override
    public void setResolutionDate(Date resolutionDate) {
        this.resolutionDate = resolutionDate;
    }

    @Override
    public Date getDuedate() {
        return this.duedate;
    }

    @Override
    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    @Override
    public Long getVotes() {
        return this.votes;
    }

    @Override
    public void setVotes(Long votes) {
        this.votes = votes;
    }

    @Override
    public Long getWatches() {
        return this.watches;
    }

    @Override
    public void setWatches(Long watches) {
        this.watches = watches;
    }

    @Override
    public Long getOriginalEstimate() {
        return this.originalEstimate;
    }

    @Override
    public void setOriginalEstimate(Long originalEstimate) {
        this.originalEstimate = originalEstimate;
    }

    @Override
    public Long getTimeSpent() {
        return this.timeSpent;
    }

    @Override
    public void setTimeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    @Override
    public Long getEstimate() {
        return this.estimate;
    }

    @Override
    public void setEstimate(Long estimate) {
        this.estimate = estimate;
    }

    @Override
    public String getSecurityLevel() {
        return this.securityLevel;
    }

    @Override
    public void setSecurityLevel(String securityLevel) {
        this.securityLevel = securityLevel;
    }

    @Override
    public void setField(String fieldName, String value) {
        try {
            fieldName = this.processFieldName(fieldName);
            BeanUtils.setProperty((Object)this, (String)fieldName, (Object)value);
        }
        catch (Exception e) {
            log.warn("Unable to set field using reflection for :" + fieldName + ":" + value);
        }
    }

    @Override
    public String getField(String fieldName) {
        try {
            fieldName = this.processFieldName(fieldName);
            return BeanUtils.getProperty((Object)this, (String)fieldName);
        }
        catch (Exception e) {
            log.warn("Unable to get field using reflection for :" + fieldName);
            return null;
        }
    }

    private String processFieldName(String fieldName) {
        if (ConstantsManager.ISSUE_TYPE_CONSTANT_TYPE.equalsIgnoreCase(fieldName)) {
            fieldName = "issueType";
        }
        return fieldName;
    }

    public String toString() {
        return "Issue {summary=" + this.summary + ", type=" + this.issueType + (this.project != null ? ", project=" + this.project : "") + "}";
    }
}

