/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.favourites.Favourite;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@PublicApi
public interface SharedEntity
extends Favourite {
    public Long getId();

    public String getName();

    public String getDescription();

    public <S extends SharedEntity> TypeDescriptor<S> getEntityType();

    public String getOwnerUserName();

    public ApplicationUser getOwner();

    public SharePermissions getPermissions();

    @Immutable
    public static final class SharePermissions
    implements Iterable<SharePermission>,
    Serializable {
        private static final SharePermission GLOBAL_PERMISSION = new SharePermissionImpl(ShareType.Name.GLOBAL, null, null, ShareRights.VIEW);
        private static final SharePermission AUTHENTICATED_PERMISSION = new SharePermissionImpl(ShareType.Name.AUTHENTICATED, null, null, ShareRights.VIEW);
        public static final SharePermissions AUTHENTICATED = new SharePermissions(Collections.singleton(AUTHENTICATED_PERMISSION));
        public static final SharePermissions GLOBAL = new SharePermissions(Collections.singleton(GLOBAL_PERMISSION));
        public static final SharePermissions PRIVATE = new SharePermissions(Collections.emptySet());
        private final Set<SharePermission> permissions;

        public SharePermissions(Set<? extends SharePermission> permissions) {
            Assertions.notNull("permissions", permissions);
            this.permissions = Collections.unmodifiableSet(permissions);
        }

        @Override
        public Iterator<SharePermission> iterator() {
            return this.permissions.iterator();
        }

        public boolean isGlobal() {
            return this.permissions.contains(GLOBAL_PERMISSION);
        }

        public boolean isAuthenticated() {
            return this.permissions.contains(AUTHENTICATED_PERMISSION);
        }

        public boolean isPrivate() {
            return this.permissions.isEmpty();
        }

        public boolean isEmpty() {
            return this.permissions.isEmpty();
        }

        public int size() {
            return this.permissions.size();
        }

        public Set<SharePermission> getPermissionSet() {
            return this.permissions;
        }

        public int hashCode() {
            return this.permissions == null ? 0 : this.permissions.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SharePermissions other = (SharePermissions)obj;
            return !(this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions));
        }

        public String toString() {
            return this.getClass().getName() + this.permissions;
        }
    }

    public static final class TypeDescriptor<S extends SharedEntity>
    implements Serializable {
        private final String name;

        TypeDescriptor(String name) {
            this.name = Assertions.notBlank("name", name);
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeDescriptor other = (TypeDescriptor)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.name;
        }

        public static final class Factory {
            private static final Factory INSTANCE = new Factory();
            private final ConcurrentMap<String, TypeDescriptor<?>> map = new ConcurrentHashMap();

            public static Factory get() {
                return INSTANCE;
            }

            public <S extends SharedEntity> TypeDescriptor<S> create(String name) {
                return this.register(new TypeDescriptor(name));
            }

            public <S extends SharedEntity> TypeDescriptor<S> register(TypeDescriptor<S> typeDescriptor) {
                Assertions.notNull("typeDescriptor", typeDescriptor);
                this.map.putIfAbsent(typeDescriptor.getName(), typeDescriptor);
                return (TypeDescriptor)this.map.get(typeDescriptor.getName());
            }
        }
    }

    public static class Identifier
    implements SharedEntity {
        private final Long id;
        private final TypeDescriptor<? extends SharedEntity> type;
        private final ApplicationUser owner;

        public Identifier(Long id, TypeDescriptor<? extends SharedEntity> type, String ownerUserName) {
            this(id, type, ComponentAccessor.getUserManager().getUserByName(ownerUserName));
        }

        public Identifier(Long id, TypeDescriptor<? extends SharedEntity> type, ApplicationUser owner) {
            Assertions.notNull("id", id);
            Assertions.notNull("type", type);
            this.id = id;
            this.type = type;
            this.owner = owner;
        }

        @Override
        public Long getId() {
            return this.id;
        }

        public TypeDescriptor<SharedEntity> getEntityType() {
            return this.type;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException(this.getClass() + " does not support name");
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException(this.getClass() + " does not support description");
        }

        @Override
        public String getOwnerUserName() {
            return this.getOwner() == null ? null : this.getOwner().getUsername();
        }

        @Override
        public ApplicationUser getOwner() {
            return this.owner;
        }

        @Override
        public SharePermissions getPermissions() {
            throw new UnsupportedOperationException(this.getClass() + " does not support SharePermissions");
        }

        @Override
        public Long getFavouriteCount() {
            return 0L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identifier that = (Identifier)o;
            if (!this.id.equals(that.id)) {
                return false;
            }
            if (!this.getOwnerKey().equals(this.getOwnerKey())) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.getOwnerKey().hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        private String getOwnerKey() {
            return this.owner == null ? "" : this.owner.getKey();
        }
    }
}

