/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.io.File;
import java.util.Set;
import javax.annotation.Nonnull;

public interface JiraHome {
    public static final String CACHES = "caches";
    public static final String DATA = "data";
    public static final String PLUGINS = "plugins";
    public static final String EXPORT = "export";
    public static final String IMPORT = "import";
    public static final String IMPORT_ATTACHMENTS = "attachments";
    public static final String INDEXES_DIR = PathUtils.joinPaths("caches", "indexesV2");
    public static final String INDEX_SNAPSHOTS = PathUtils.joinPaths(INDEXES_DIR, "snapshots");
    public static final String LOG = "log";
    @Deprecated
    public static final Set<String> subdirs = CollectionBuilder.newBuilder("caches", "data", "plugins", "export", "import", PathUtils.joinPaths("import", "attachments"), INDEX_SNAPSHOTS, "log").asSet();
    public static final Set<String> localsubdirs = CollectionBuilder.newBuilder("caches", "plugins", "log").asSet();
    public static final Set<String> sharedsubdirs = CollectionBuilder.newBuilder("data", "plugins", "export", "import", PathUtils.joinPaths("import", "attachments"), INDEX_SNAPSHOTS).asSet();

    public String getHomePath();

    @Nonnull
    public File getHome();

    @Nonnull
    public File getLocalHome();

    public String getLocalHomePath();

    public File getLogDirectory();

    public File getCachesDirectory();

    public File getSharedCachesDirectory();

    public File getExportDirectory();

    public File getImportDirectory();

    public File getImportAttachmentsDirectory();

    public File getPluginsDirectory();

    public File getDataDirectory();

    public File getIndexSnapshotsDirectory();
}

