/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.user.anonymize;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@ExperimentalApi
@EventName(value="jira.user.anonymization.handler.executed")
public class UserAnonymizationHandlerExecutedEvent {
    private final Operation operation;
    private final String pluginKey;
    private final String handlerKey;
    private final boolean success;
    private final long duration;

    private UserAnonymizationHandlerExecutedEvent(Operation operation, String pluginKey, String handlerKey, boolean success, Duration duration) {
        this.operation = Objects.requireNonNull(operation);
        this.pluginKey = Objects.requireNonNull(pluginKey);
        this.handlerKey = Objects.requireNonNull(handlerKey);
        this.success = success;
        this.duration = Objects.requireNonNull(duration).toMillis();
    }

    public static UserAnonymizationHandlerExecutedEvent affectedEntities(String pluginKey, String handlerKey, boolean success, Duration duration) {
        return UserAnonymizationHandlerExecutedEvent.create(Operation.AFFECTED_ENTITIES, pluginKey, handlerKey, success, duration);
    }

    public static UserAnonymizationHandlerExecutedEvent update(String pluginKey, String handlerKey, boolean success, Duration duration) {
        return UserAnonymizationHandlerExecutedEvent.create(Operation.UPDATE, pluginKey, handlerKey, success, duration);
    }

    public static UserAnonymizationHandlerExecutedEvent numberOfTasks(String pluginKey, String handlerKey, boolean success, Duration duration) {
        return UserAnonymizationHandlerExecutedEvent.create(Operation.NUMBER_OF_TASKS, pluginKey, handlerKey, success, duration);
    }

    private static UserAnonymizationHandlerExecutedEvent create(Operation operation, String pluginKey, String handlerKey, boolean success, Duration duration) {
        return new UserAnonymizationHandlerExecutedEvent(operation, pluginKey, handlerKey, success, duration);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getHandlerKey() {
        return this.handlerKey;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAnonymizationHandlerExecutedEvent that = (UserAnonymizationHandlerExecutedEvent)o;
        return this.operation == that.operation && this.success == that.success && Objects.equals(this.pluginKey, that.pluginKey) && Objects.equals(this.handlerKey, that.handlerKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.success, this.pluginKey, this.handlerKey});
    }

    public String toString() {
        return "UserAnonymizationHandlerExecutedEvent{operation=" + (Object)((Object)this.operation) + ", pluginKey='" + this.pluginKey + '\'' + ", handlerKey='" + this.handlerKey + '\'' + ", success=" + this.success + ", duration=" + this.duration + '}';
    }

    private static enum Operation {
        AFFECTED_ENTITIES,
        UPDATE,
        NUMBER_OF_TASKS;

    }
}

