/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.properties.PropertiesAccessor;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

@Internal
public class SystemPropertiesAccessor
implements PropertiesAccessor {
    @Override
    public Boolean getBoolean(@Nonnull String key) {
        return Boolean.getBoolean(key);
    }

    @Override
    public String getProperty(@Nonnull String key) {
        return System.getProperty(key);
    }

    @Override
    public void setProperty(@Nonnull String key, @Nonnull String value) {
        System.setProperty(key, value);
    }

    @Override
    public void unsetProperty(@Nonnull String key) {
        System.clearProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() {
        Properties systemProperties;
        Properties properties = new Properties();
        Properties properties2 = systemProperties = System.getProperties();
        synchronized (properties2) {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        return properties;
    }

    @Override
    public void setProperties(@Nonnull Properties props) {
        System.setProperties(props);
    }

    @Override
    public Integer getInteger(@Nonnull String key) {
        return Integer.getInteger(key);
    }

    @Override
    public Long getLong(@Nonnull String key) {
        return Long.getLong(key);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void refresh(@Nonnull String key) {
    }
}

