/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonProperty;

public class IssueTypeJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String description;
    @JsonProperty
    private String iconUrl;
    @JsonProperty
    private String name;
    @JsonProperty
    private boolean subtask;
    @JsonProperty
    private Long avatarId;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSubtask() {
        return this.subtask;
    }

    public void setSubtask(boolean subtask) {
        this.subtask = subtask;
    }

    public Long getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(long avatarId) {
        this.avatarId = avatarId;
    }

    public static Collection<IssueTypeJsonBean> shortBeans(Collection<IssueType> issuetypes, JiraBaseUrls urls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)issuetypes.size());
        for (IssueType from : issuetypes) {
            result.add(IssueTypeJsonBean.shortBean(from, urls));
        }
        return result;
    }

    public static IssueTypeJsonBean shortBean(IssueType issuetype, JiraBaseUrls urls) {
        String iconAbsoluteUrl;
        if (issuetype == null) {
            return null;
        }
        try {
            iconAbsoluteUrl = new URL(issuetype.getIconUrl()).toString();
        }
        catch (MalformedURLException e) {
            iconAbsoluteUrl = urls.baseUrl() + issuetype.getIconUrl();
        }
        IssueTypeJsonBean bean = new IssueTypeJsonBean();
        bean.self = urls.restApi2BaseUrl() + "issuetype/" + JiraUrlCodec.encode(issuetype.getId().toString());
        bean.id = issuetype.getId().toString();
        bean.description = issuetype.getDescTranslation();
        bean.name = issuetype.getNameTranslation();
        bean.subtask = issuetype.isSubTask();
        bean.iconUrl = iconAbsoluteUrl;
        bean.avatarId = issuetype.getAvatar() != null ? issuetype.getAvatar().getId() : null;
        return bean;
    }

    public static IssueTypeJsonBean shortBean(String self, String id, String name, String description, boolean subtask, String iconUrl) {
        return IssueTypeJsonBean.shortBean(self, id, name, description, subtask, null, iconUrl);
    }

    public static IssueTypeJsonBean shortBean(String self, String id, String name, String description, boolean subtask, Long avatarId, String iconUrl) {
        IssueTypeJsonBean bean = new IssueTypeJsonBean();
        bean.self = self;
        bean.id = id;
        bean.name = name;
        bean.description = description;
        bean.subtask = subtask;
        bean.iconUrl = iconUrl;
        bean.avatarId = avatarId;
        return bean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypeJsonBean that = (IssueTypeJsonBean)o;
        return this.subtask == that.subtask && Objects.equals(this.self, that.self) && Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && Objects.equals(this.iconUrl, that.iconUrl) && Objects.equals(this.name, that.name) && Objects.equals(this.avatarId, that.avatarId);
    }

    public int hashCode() {
        return Objects.hash(this.self, this.id, this.description, this.iconUrl, this.name, this.subtask, this.avatarId);
    }
}

