/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public interface DataImportService {
    public ImportValidationResult validateImport(ApplicationUser var1, DataImportParams var2);

    public ImportResult doImport(ApplicationUser var1, ImportValidationResult var2, TaskProgressSink var3);

    public static class ImportResult
    extends ServiceResultImpl
    implements Serializable {
        private final ImportError error;
        private final String specificErrorMessage;
        private final List<String> validationErrorMessages;
        private transient DataImportParams params;

        private ImportResult(DataImportParams params, ErrorCollection errorCollection, ImportError error, String specificErrorMessage, List<String> validationErrorMessages) {
            super(errorCollection);
            this.params = params;
            this.error = error;
            this.specificErrorMessage = specificErrorMessage;
            this.validationErrorMessages = validationErrorMessages;
        }

        public ImportError getImportError() {
            return this.error;
        }

        public String getSpecificErrorMessage() {
            return this.specificErrorMessage;
        }

        public List<String> getValidationErrorMessages() {
            return this.validationErrorMessages;
        }

        @Override
        public boolean isValid() {
            return super.isValid() && this.error.equals((Object)ImportError.NONE);
        }

        public DataImportParams getParams() {
            return this.params;
        }

        public static class Builder {
            private final ErrorCollection errors = new SimpleErrorCollection();
            private ImportError error = ImportError.NONE;
            private String specificErrorMessage;
            private final DataImportParams params;
            private final List<String> validationErrorMessages = Lists.newArrayList();

            public Builder(DataImportParams params) {
                this.params = params;
            }

            public ErrorCollection getErrorCollection() {
                return this.errors;
            }

            public Builder addErrorMessage(String errorMessage) {
                this.errors.addErrorMessage(errorMessage);
                return this;
            }

            public Builder addErrorMessage(String message, ErrorCollection.Reason reason) {
                this.errors.addErrorMessage(message, reason);
                return this;
            }

            public Builder addErrorMessages(Iterable<String> errorMessages) {
                for (String errorMessage : errorMessages) {
                    this.errors.addErrorMessage(errorMessage);
                }
                return this;
            }

            public void setSpecificError(ImportError error, String specificErrorMessage) {
                this.error = error;
                this.specificErrorMessage = specificErrorMessage;
            }

            public Builder withSpecificError(ImportError error, String specificErrorMessage) {
                this.error = error;
                this.specificErrorMessage = specificErrorMessage;
                return this;
            }

            public Builder withImportError(ImportError error) {
                this.error = error;
                return this;
            }

            public Builder addValidationErrorMessages(Collection<String> validationErrorMessages) {
                this.validationErrorMessages.addAll(validationErrorMessages);
                return this;
            }

            public ImportResult build() {
                return new ImportResult(this.params, this.errors, this.error, this.specificErrorMessage, this.validationErrorMessages);
            }

            public boolean isValid() {
                return !this.errors.hasAnyErrors() && this.error.equals((Object)ImportError.NONE);
            }
        }
    }

    public static class ImportValidationResult
    extends ServiceResultImpl {
        private final DataImportParams params;

        public ImportValidationResult(ErrorCollection errorCollection, DataImportParams params) {
            super(errorCollection);
            this.params = params;
        }

        public DataImportParams getParams() {
            return this.params;
        }
    }

    public static enum ImportError {
        NONE,
        FAILED_VALIDATION,
        UPGRADE_EXCEPTION,
        CUSTOM_PATH_EXCEPTION,
        DOWNGRADE_FROM_ONDEMAND;

    }
}

