/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;

@PublicApi
public interface IssueSecurityLevelService {
    public UpdateValidationResult validateUpdate(ApplicationUser var1, IssueSecurityLevel var2, String var3, String var4);

    public ServiceOutcome<IssueSecurityLevel> update(ApplicationUser var1, UpdateValidationResult var2);

    public CreateValidationResult validateCreate(ApplicationUser var1, long var2, String var4, String var5);

    public ServiceOutcome<IssueSecurityLevel> create(ApplicationUser var1, CreateValidationResult var2);

    public static abstract class LevelValidationResult {
        private final IssueSecurityLevel level;
        private final ErrorCollection errors;

        public IssueSecurityLevel getLevel() {
            return this.level;
        }

        public ErrorCollection getErrors() {
            return this.errors;
        }

        public boolean isValid() {
            return !this.getErrors().hasAnyErrors();
        }

        protected LevelValidationResult(IssueSecurityLevel level, ErrorCollection errors) {
            this.level = level;
            this.errors = errors;
        }
    }

    public static class UpdateValidationResult
    extends LevelValidationResult {
        UpdateValidationResult(IssueSecurityLevel level, ErrorCollection errors) {
            super(level, errors);
        }
    }

    public static class CreateValidationResult
    extends LevelValidationResult {
        CreateValidationResult(IssueSecurityLevel level, ErrorCollection errors) {
            super(level, errors);
        }
    }
}

