/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexpUtils {
    private static final Logger log = LoggerFactory.getLogger(RegexpUtils.class);

    public static String replaceAll(String str, String regex, String replacement) {
        Pattern pattern;
        try {
            pattern = new Perl5Compiler().compile(regex);
        }
        catch (MalformedPatternException e) {
            log.error("Error parsing regexp '" + regex + "' - " + (Object)((Object)e), (Throwable)e);
            return null;
        }
        return Util.substitute((PatternMatcher)new Perl5Matcher(), (Pattern)pattern, (Substitution)new Perl5Substitution(replacement), (String)str, (int)-1);
    }

    public static String wildcardToRegex(String wildcard) {
        return RegexpUtils.wildcardToRegex(wildcard, true);
    }

    public static String wildcardToRegex(String wildcard, boolean exactMatchRequired) {
        StringBuilder s = new StringBuilder(wildcard.length() + 4);
        if (exactMatchRequired) {
            s.append('^');
        }
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        if (exactMatchRequired) {
            s.append('$');
        }
        return s.toString();
    }
}

