package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalSpi;

/**
 * Performs operations related to a change of a user name, e.g. in response to a user name change it should update
 * mentions of the user in comments.
 * <p>
 * Those extension points are executed as the third step of the user anonymization process, after {@link UserAnonymizationHandler}.
 * Any errors returned by the implementations will <b>not</b> stop the process.
 * <p>
 * To register an instance of this handler to be executed by Jira, implement this interface and add
 * an {@code user-name-change-handler} module to the atlassian-plugin.xml, e.g.:
 * <p>
 * {@code <user-name-change-handler key="my-user-name-change-handler" class="com.example.UserNameChangeHandlerImpl"
 * name="My user name change handler" application="jira" />}
 */
@ExperimentalSpi
public interface UserNameChangeHandler extends AnonymizationHandler<UserPropertyChangeParameter> {
}
