package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalSpi;

/**
 * Performs operations related to a change of a user key, e.g. it should update
 * foreign keys referencing this user key in the database.
 * <p>
 * Those extension points are executed as the third step of the user anonymization process, after {@link UserAnonymizationHandler}.
 * Any errors returned by the implementations will <b>not</b> stop the process.
 * <p>
 * To register an instance of this handler to be executed by Jira, implement this interface and add
 * an {@code user-key-change-handler} module to the atlassian-plugin.xml, e.g.:
 * <p>
 * {@code <user-key-change-handler key="my-user-key-change-handler" class="com.example.UserKeyChangeHandlerImpl"
 * name="My user key change handler" application="jira" />}
 */
@ExperimentalSpi
public interface UserKeyChangeHandler extends AnonymizationHandler<UserPropertyChangeParameter> {
}
