package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalSpi;

/**
 * Deletes or anonymizes user's personal data and data only accessible by the single user. For example, removes
 * private dashboards or filters, and anonymizes user's profile information, like full name or email address.
 * <p>
 * This extension point is executed as the second step of the user anonymization process, after {@link OwnershipTransferParameter}.
 * Any errors returned by the implementations will <b>not</b> stop the process.
 * <p>
 * To register an instance of this handler to be executed by Jira, implement this interface and add
 * an {@code user-anonymization-handler} module to the atlassian-plugin.xml, e.g.:
 * <p>
 * {@code <user-anonymization-handler key="my-user-anonymization-handler" class="com.example.UserAnonymizationHandlerImpl"
 * name="My user anonymization handler" application="jira" />}
 */
@ExperimentalSpi
public interface UserAnonymizationHandler extends AnonymizationHandler<UserAnonymizationParameter> {
}
