package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalSpi;

import javax.annotation.Nonnull;
import java.net.URI;
import java.util.Objects;

/**
 * A link allowing to view the data relating to a particular {@link AffectedEntity}.
 */
@ExperimentalSpi
public class AffectedEntityLink {
    private final URI uri;
    private final String displayNameKey;

    public AffectedEntityLink(@Nonnull URI uri, @Nonnull String displayNameKey) {
        this.uri = Objects.requireNonNull(uri);
        this.displayNameKey = Objects.requireNonNull(displayNameKey);
    }

    /**
     * The URI leading to a page that allows to find the affected data.
     */
    @Nonnull
    public URI getUri() {
        return uri;
    }

    /**
     * The i18n key used to display the description of the link.
     */
    @Nonnull
    public String getDisplayNameKey() {
        return displayNameKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AffectedEntityLink that = (AffectedEntityLink) o;
        return uri.equals(that.uri) && displayNameKey.equals(that.displayNameKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uri, displayNameKey);
    }

    @Override
    public String toString() {
        return uri.toString();
    }
}
