package com.atlassian.jira.jql.query;

import com.atlassian.jira.util.Function;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.Query;

public class LongPointRangeQueryFactory<T> extends AbstractRangeQueryFactory<T, Long>{

    public LongPointRangeQueryFactory(final Function<T, Long> valueFactory) {
        super(valueFactory);
    }

    @Override
    Query handleLessThan(final String fieldName, final T value) {
        return LongPoint.newRangeQuery(fieldName, Long.MIN_VALUE, valueFactory.apply(value) - 1);
    }

    @Override
    Query handleLessThanEquals(final String fieldName, final T value) {
        return LongPoint.newRangeQuery(fieldName, Long.MIN_VALUE, valueFactory.apply(value));
    }

    @Override
    Query handleGreaterThan(final String fieldName, final T value) {
        return LongPoint.newRangeQuery(fieldName, valueFactory.apply(value) + 1, Long.MAX_VALUE);
    }

    @Override
    Query handleGreaterThanEquals(final String fieldName, final T value) {
        return LongPoint.newRangeQuery(fieldName, valueFactory.apply(value), Long.MAX_VALUE);
    }

    @Override
    Query handleDuring(final String fieldName, final T lowerValue, final T upperValue) {
        return LongPoint.newRangeQuery(fieldName, valueFactory.apply(lowerValue), valueFactory.apply(upperValue));
    }
}
