package com.atlassian.jira.index.summary;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.cluster.ClusterInfo;
import java.util.Map;

/**
 * A component responsible for collecting the summary information about the JIRA index.
 *
 * The returned summaries are node-specific, and relate to the node with the ID returned by {@link ClusterInfo#getNodeId()}.
 *
 * @since v7.2.10
 */
@ExperimentalApi
public interface IndexSummarizer {

    /**
     * Summarizes the issue index by providing various data about the current node's index.
     *
     * @return issue index summary or error(s)
     */
    ServiceOutcome<IssueIndexSummary> summarizeIssueIndex();

    /**
     * Summarizes replication queues from all other nodes to the current node.
     * Returned value maps sender node IDs to {@link IndexReplicationQueueSummary} objects.
     *
     * @return map of all visible index replication queues or error(s)
     */
    ServiceOutcome<Map<String, IndexReplicationQueueSummary>> summarizeIndexReplicationQueues();
}
