package com.atlassian.jira.event.user.anonymize;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.ExperimentalApi;

import java.util.Objects;

/**
 * This event is sent when a user anonymization has been started.
 *
 * @since v8.4
 */
@ExperimentalApi
@EventName("jira.user.anonymization.started")
public class UserAnonymizationStartedEvent {
    private final String userKey;
    private final String userName;

    public UserAnonymizationStartedEvent(String userKey, String userName) {
        this.userKey = userKey;
        this.userName = userName;
    }

    /**
     * User key before anonymization process.
     *
     * @return User key before anonymization process.
     */
    public String getUserKey() {
        return userKey;
    }

    /**
     * User name before anonymization process.
     *
     * @return User name before anonymization process.
     */

    public String getUserName() {
        return userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserAnonymizationStartedEvent that = (UserAnonymizationStartedEvent) o;
        return Objects.equals(userKey, that.userKey) &&
                Objects.equals(userName, that.userName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userKey, userName);
    }

    @Override
    public String toString() {
        return "UserAnonymizationStartedEvent{" +
                "userKey='" + userKey + '\'' +
                ", userName='" + userName + '\'' +
                '}';
    }
}
