package com.atlassian.jira.event.user.anonymize;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.ExperimentalApi;

import java.util.Objects;

/**
 * This event is sent when a user anonymization is being pre-validated, effectively meaning that the user anonymization
 * screen has been accessed for a user with the given user key.
 *
 * @since v8.4
 */
@ExperimentalApi
@EventName("jira.user.anonymization.prevalidated")
public class UserAnonymizationPrevalidateEvent {
    private final String userKey;

    public UserAnonymizationPrevalidateEvent(String userKey) {
        this.userKey = userKey;
    }

    /**
     * User key before anonymization process.
     *
     * @return User key before anonymization process.
     */
    public String getUserKey() {
        return userKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserAnonymizationPrevalidateEvent that = (UserAnonymizationPrevalidateEvent) o;
        return Objects.equals(userKey, that.userKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userKey);
    }

    @Override
    public String toString() {
        return "UserAnonymizationPrevalidateEvent{" +
                ", oldUserKey='" + userKey + '\'' +
                '}';
    }
}
