package com.atlassian.jira.event.sharedentity;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.sharing.SharedEntity;

import javax.annotation.Nonnull;

/**
 * Event published when shared entity (i.e. filer or dashboard) has been created
 *
 * @since v7.12
 */
@ExperimentalApi
public class SharedEntityCreatedEvent extends AbstractSharedEntityEvent {
    public SharedEntityCreatedEvent(@Nonnull SharedEntity createdEntity) {
        super(null, createdEntity);
    }
}
