package com.atlassian.jira.event.property;

import com.atlassian.annotations.ExperimentalApi;

@ExperimentalApi
public class BooleanApplicationPropertySetEvent extends AbstractApplicationPropertySetEvent<Boolean> {
    private boolean previousValue;

    public BooleanApplicationPropertySetEvent(final String applicationPropertyKey, final boolean value, final boolean previousValue) {
        super(applicationPropertyKey, value);
        this.previousValue = previousValue;
    }

    public boolean wasChanged() {
        return getPropertyValue() != previousValue;
    }
}
