package com.atlassian.jira.event.issue;

import com.atlassian.annotations.ExperimentalApi;

import java.util.Collection;
import java.util.Collections;

/**
 * Event published when issue is archived
 *
 * @since 8.1
 */
@ExperimentalApi
public class IssuesArchivedEvent extends AbstractArchivingEvent {
    public IssuesArchivedEvent(Collection<Long> issueIds) {
        super(issueIds);
    }

    public IssuesArchivedEvent(Long issueId) {
        super(Collections.singleton(issueId));
    }
}
