package com.atlassian.jira.event.cluster;

import com.atlassian.annotations.PublicApi;

/**
 * Send when replication to node is restored.
 * Potentially plugins need to clear its caches.
 *
 * @since v7.2.12
 */
@PublicApi
public class CacheReplicationResumedEvent {
    private final String nodeId;

    public CacheReplicationResumedEvent(final String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return nodeId;
    }
}
