package com.atlassian.jira.config.properties;

import com.atlassian.annotations.Internal;
/**
 * Provides URL for logo and favicon depending on active products licences or custom set by user.
 *
 * @see LookAndFeelBean
 */
@Internal
public interface LogoProvider {

    /**
     * Returns logo URL depending on product or URL from LookAndFeel if set by user
     */
    String getLogo();

    /**
     * Returns favicon URL depending on product or URL from LookAndFeel if set by user
     */
    String getFavicon();
}
