package com.atlassian.jira.config.properties;

import com.atlassian.annotations.Internal;

import java.util.Optional;

/**
 * Provides default colors (like header background or text colors) for the ADG3 color scheme.
 * These values aren't customizable by users.
 *
 * @see LookAndFeelBean
 */
@Internal
public interface LnFDefaultColorProvider {

    /**
     * For property name that has an associated default color returns
     * {@code Optional.of(<color-hex>)}, "color-hex" being a
     * representation of color that starts with a hash ("#"),
     * followed by six hexadecimal digits, e.g. "#abcdef".
     *
     * If the given key is not associated with any color, return
     * {@code Optional.empty()}
     */
    Optional<String> getValue(String key);
}
