/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.user.anonymize;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.ExperimentalApi;
import java.util.Objects;

@ExperimentalApi
@EventName(value="jira.user.anonymized")
public class UserAnonymizedEvent {
    private final String userKey;
    private final String userName;
    private final String oldUserKey;
    private final String oldUserName;

    public UserAnonymizedEvent(String userKey, String userName, String oldUserKey, String oldUserName) {
        this.userKey = userKey;
        this.userName = userName;
        this.oldUserKey = oldUserKey;
        this.oldUserName = oldUserName;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getOldUserKey() {
        return this.oldUserKey;
    }

    public String getOldUserName() {
        return this.oldUserName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAnonymizedEvent that = (UserAnonymizedEvent)o;
        return Objects.equals(this.userKey, that.userKey) && Objects.equals(this.userName, that.userName) && Objects.equals(this.oldUserKey, that.oldUserKey) && Objects.equals(this.oldUserName, that.oldUserName);
    }

    public int hashCode() {
        return Objects.hash(this.userKey, this.userName, this.oldUserKey, this.oldUserName);
    }

    public String toString() {
        return "UserAnonymizedEvent{userKey='" + this.userKey + '\'' + ", userName='" + this.userName + '\'' + ", oldUserKey='" + this.oldUserKey + '\'' + ", oldUserName='" + this.oldUserName + '\'' + '}';
    }
}

