/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public class DuplicatedUsersToDirectoriesMapping {
    public static final DuplicatedUsersToDirectoriesMapping EMPTY = new DuplicatedUsersToDirectoriesMapping((Map<String, List<DirectoryWithUserActive>>)ImmutableMap.of());
    private final Map<String, List<DirectoryWithUserActive>> usernameToDirectories;

    private DuplicatedUsersToDirectoriesMapping(Map<String, List<DirectoryWithUserActive>> usernameToDirectories) {
        this.usernameToDirectories = ImmutableMap.copyOf((Map)Maps.transformValues(usernameToDirectories, ImmutableList::copyOf));
    }

    public int userCount() {
        return this.usernameToDirectories.size();
    }

    public List<DirectoryWithUserActive> getDirectoriesForUser(String username) {
        return this.usernameToDirectories.getOrDefault(IdentifierUtils.toLowerCase((String)username), (List<DirectoryWithUserActive>)ImmutableList.of());
    }

    public Set<String> getUsernames() {
        return this.usernameToDirectories.keySet();
    }

    public static class DirectoryWithUserActive {
        private final long directoryId;
        private final String directoryName;
        private final boolean userActive;

        private DirectoryWithUserActive(long directoryId, String directoryName, boolean userActive) {
            this.directoryId = directoryId;
            this.directoryName = directoryName;
            this.userActive = userActive;
        }

        public long getDirectoryId() {
            return this.directoryId;
        }

        public String getDirectoryName() {
            return this.directoryName;
        }

        public boolean isUserActive() {
            return this.userActive;
        }
    }

    public static class Builder {
        private final Map<String, List<DirectoryWithUserActive>> mutableMap = new HashMap<String, List<DirectoryWithUserActive>>();

        public Builder addDirectoryForUser(String username, Directory directory, boolean isUserActive) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"User name required");
            Preconditions.checkArgument((directory != null ? 1 : 0) != 0, (Object)"Directory required");
            this.mutableMap.computeIfAbsent(IdentifierUtils.toLowerCase((String)username), ignore -> new LinkedList()).add(new DirectoryWithUserActive(directory.getId(), directory.getName(), isUserActive));
            return this;
        }

        public DuplicatedUsersToDirectoriesMapping buildDuplicatedUsers() {
            return this.mutableMap.isEmpty() ? EMPTY : new DuplicatedUsersToDirectoriesMapping(Maps.filterEntries(this.mutableMap, entry -> this.isUserDuplicated((List)entry.getValue())));
        }

        private boolean isUserDuplicated(List<DirectoryWithUserActive> listOfDirectories) {
            return listOfDirectories.stream().skip(1L).anyMatch(DirectoryWithUserActive::isUserActive);
        }
    }
}

