/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ExperimentalApi
@ParametersAreNonnullByDefault
public interface TerminologyEntryWriter {
    public TerminologyValidationResult validateAndPrepareTerminologyChange(Collection<TerminologyEntry> var1);

    public void changeTerminology(TerminologyValidationResult var1);

    @ExperimentalApi
    @ParametersAreNonnullByDefault
    @ReturnValuesAreNonnullByDefault
    public static class TerminologyValidationResult
    extends ServiceResultImpl {
        private final Collection<TerminologyEntry> terminologyEntries;

        TerminologyValidationResult(@Nullable Collection<TerminologyEntry> terminologyEntries, ErrorCollection errors) {
            super(errors);
            if (this.isValidEntryWithErrors(terminologyEntries, errors) || this.isInvalidEntryWithNoErrors(terminologyEntries, errors)) {
                throw new IllegalArgumentException(String.format("Result must be either valid with entry or invalid with errors. Current values: Entry - '%s', Errors - '%s'", terminologyEntries, errors));
            }
            this.terminologyEntries = terminologyEntries;
        }

        private boolean isValidEntryWithErrors(@Nullable Collection<TerminologyEntry> terminologyEntries, ErrorCollection errors) {
            return terminologyEntries != null && errors.hasAnyErrors();
        }

        private boolean isInvalidEntryWithNoErrors(@Nullable Collection<TerminologyEntry> terminologyEntries, ErrorCollection errors) {
            return terminologyEntries == null && !errors.hasAnyErrors();
        }

        static TerminologyValidationResult ok(Collection<TerminologyEntry> terminologyEntries) {
            return new TerminologyValidationResult(terminologyEntries, new SimpleErrorCollection());
        }

        static TerminologyValidationResult error(ErrorCollection errors) {
            return new TerminologyValidationResult(null, errors);
        }

        @Nullable
        public Collection<TerminologyEntry> getTerminologyEntries() {
            return this.terminologyEntries;
        }
    }
}

