package com.atlassian.jira.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Optional;

/**
 * Contains static utility methods pertaining to the {@code Long} type.
 *
 * @since 6.4.9
 */
public class Longs {
    /**
     * @deprecated to Use toLongMaybe instead, since v7.4.0
     */
    @Nonnull
    @Deprecated
    public static com.google.common.base.Optional<Long> toLong(@Nullable String value) {
        return toLongMaybe(value).map(com.google.common.base.Optional::of).orElseGet(com.google.common.base.Optional::absent);
    }

    /**
     * Parses the string argument as a {@code Long} by delegating to {@link Long#parseLong(String)}, but returns an
     * {@link Optional<Long>} instead of throwing a {@link NumberFormatException}.
     *
     * @param value a {@code String} containing the {@code Long} representation to be parsed
     * @return an {@code Optional<Long>}, containing either the parsed {@code Long} value or nothing if the value could
     * not be parsed
     * @since v7.4.0
     */
    @Nonnull
    public static Optional<Long> toLongMaybe(@Nullable String value) {
        try {
            return Optional.of(Long.parseLong(value));
        } catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    /**
     * Compares safely two nullable longs.
     *
     * @return {@code true} if both values are null or contain equal numbers. {@code false} otherwise
     */
    public static boolean nullableLongsEquals(@Nullable Long number1, @Nullable Long number2) {
        if (number1 == null) {
            return null == number2;
        } else {
            return number1.equals(number2);
        }
    }

    /**
     * is this String value a valid Long
     *
     * @param s The string to check
     * @return True if valid long, false otherwise
     * @since v7.4.0
     */
    public static boolean isLong(String s) {
        return com.google.common.primitives.Longs.tryParse(s) != null;
    }
}
