package com.atlassian.jira.user.anonymize;

/**
 * Performs operations related to a change of a user name, e.g. in response to a user name change it should update
 * mentions of the user in comments.
 * <p>
 * Those extension points are executed as the fourth step of the user anonymization process, after {@link UserKeyChangeHandler}.
 * Any errors returned by the implementations will <b>not</b> stop the process.
 * <p>
 * To register an instance of this handler to be executed by Jira, implement this interface and add
 * an {@code user-name-change-handler} module to the atlassian-plugin.xml, e.g.:
 * <p>
 * <pre>{@code
 * <user-name-change-handler
 *     key="my-user-name-change-handler"
 *     class="com.example.UserNameChangeHandlerImpl"
 *     i18n-name-key="name.change.handler.name">
 *         <restrict application="jira" version="[8.3.0,)" />
 *  </user-name-change-handler>
 *  }</pre>
 *
 * @see AnonymizationHandler
 * @see OwnershipTransferHandler
 * @see UserAnonymizationHandler
 * @see UserKeyChangeHandler
 * @since 8.3
 */
public interface UserNameChangeHandler extends AnonymizationHandler<UserPropertyChangeParameter> {
}
