package com.atlassian.jira.user.anonymize;

/**
 * Deletes or anonymizes user's personal data and data only accessible by the single user. For example, removes
 * private dashboards or filters, and anonymizes user's profile information, like full name or email address.
 * <p>
 * This extension point is executed as the second step of the user anonymization process, after {@link OwnershipTransferHandler}.
 * Any errors returned by the implementations will <b>not</b> stop the process.
 * <p>
 * To register an instance of this handler to be executed by Jira, implement this interface and add
 * an {@code user-anonymization-handler} module to the atlassian-plugin.xml, e.g.:
 * <p>
 * <pre>{@code
 * <user-anonymization-handler
 *     key="my-user-anonymization-handler"
 *     class="com.example.UserAnonymizationHandlerImpl"
 *     i18n-name-key="anonymization.handler.name">
 *         <restrict application="jira" version="[8.3.0,)" />
 *  </user-anonymization-handler>
 *  }</pre>
 *
 * @see AnonymizationHandler
 * @see OwnershipTransferHandler
 * @see UserKeyChangeHandler
 * @see UserNameChangeHandler
 * @since 8.3
 */
public interface UserAnonymizationHandler extends AnonymizationHandler<UserAnonymizationParameter> {
}
