package com.atlassian.jira.upgrade;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.Optional;

/**
 * Provides read-only access to the upgrade history of the current JIRA instance.
 *
 * @since 7.5
 */
public interface UpgradeVersionHistoryReader {

    /**
     * Returns the complete version upgrade history, in reverse chronological order.
     *
     * @return see above
     */
    @Nonnull
    List<UpgradeVersionHistoryItem> getAllUpgradeVersionHistory();

    /**
     * Returns the most recent upgrade, if any.
     *
     * @return see above
     */
    @Nonnull
    default Optional<UpgradeVersionHistoryItem> getLatestUpgrade() {
        return getAllUpgradeVersionHistory().stream().findFirst();
    }
}
