package com.atlassian.jira.template;

import com.atlassian.annotations.ExperimentalApi;

/**
 * @since 8.14
 * Checks whether the instance is licensed for Custom email templates
 */
@ExperimentalApi()
public interface CustomTemplatesFeatureAvailabilityCheck {
    boolean isLicensedForCustomEmailTemplates();
    boolean isDatabaseBuildNumberHighEnough();

    default boolean isFeatureFullyAvailable() {
        return isLicensedForCustomEmailTemplates() &&
                isDatabaseBuildNumberHighEnough();
    }
}
