package com.atlassian.jira.sharing.rights;

import com.atlassian.annotations.ExperimentalApi;

/**
 * @since v7.12
 */
@ExperimentalApi
public enum ShareRights implements ShareRight {
    VIEW(true, false),
    VIEW_EDIT(true, true);

    private final boolean hasViewRights;
    private final boolean hasEditRights;

    ShareRights(boolean hasViewRights, boolean hasEditRights) {
        this.hasViewRights = hasViewRights;
        this.hasEditRights = hasEditRights;
    }

    @Override
    public boolean hasEditRightsGranted() {
        return hasEditRights;
    }

    @Override
    public boolean hasViewRightsGranted() {
        return hasViewRights;
    }
}