package com.atlassian.jira.project.archiving;

/**
 * Check for is instance is licenced for archiving operations
 *
 * @since v8.4
 */
public interface ArchivingLicenseCheck {

    /**
     * Checks whether instance is licenced for issue archiving
     * @return boolean
     */
    boolean isLicensedForIssueArchiving();

    /**
     * Checks whether instance is licenced for project archiving
     * @return boolean
     */
    boolean isLicensedForProjectArchiving();

    /**
     * Checks whether instance is licenced for archiving
     * @return boolean
     */
    boolean isLicensedForArchiving();
}
