package com.atlassian.jira.issue.index;

import com.atlassian.annotations.Internal;

/**
 * These feature flags enables indexing improvements that reduces indexing time and index size for instances
 * with large number of custom fields.
 *
 * @since 8.9
 */
@Internal
public interface IndexingFeatures {
    /**
     * Returns true if custom field value driven index is enabled otherwise false.
     */
    boolean isCFValueDrivenIndexingEnabled();

    /**
     * Returns true if local context index is enabled otherwise false.
     */
    boolean isLocalContextIndexingEnabled();

    /**
     * Returns true if skip indexing null is enabled otherwise false.
     */
    boolean isSkipIndexingNullEnabled();

    /**
     * Returns number representing batch size of custom field value retrieval. Never less than 1. Default value is 50. To disable batching set the value to 1.
     */
    int getCustomFieldIndexingBatchSize();
}
