package com.atlassian.jira.issue.fields.renderer;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.ServiceOutcome;

import javax.annotation.Nonnull;

/**
 * @since 8.16
 */
@Internal
public interface EditorMarkupService {
    /**
     * Generates an editor field for given parameters
     *
     * @param parameters an object containing field parameters {@link EditorMarkupParameters}
     * @return html for editor field
     */
    ServiceOutcome<String> getEditorMarkupForField(@Nonnull EditorMarkupParameters parameters);
}
