package com.atlassian.jira.issue.fields.renderer;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

import javax.validation.constraints.NotEmpty;

/**
 * Data transfer object used with {@link EditorMarkupService}.
 * Only the fieldId property is required.
 *
 * @since v8.16
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class EditorMarkupParameters {
    @NotEmpty
    @JsonProperty
    private String fieldId;

    @JsonProperty
    private String fieldName;

    @JsonProperty
    private String issueKey;

    @JsonProperty
    private String value;

    public EditorMarkupParameters(String fieldId, String fieldName, String issueKey, String value) {
        this.fieldId = fieldId;
        this.fieldName = fieldName;
        this.issueKey = issueKey;
        this.value = value;
    }

    public EditorMarkupParameters() {
    }

    public String getFieldId() {
        return fieldId;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getIssueKey() {
        return issueKey;
    }

    public String getValue() {
        return value;
    }
}
