package com.atlassian.jira.index.summary;

import com.atlassian.annotations.ExperimentalApi;
import java.time.Instant;

/**
 * Representation of an entry in the index replication queue.
 *
 * @since v7.2.10
 */
@ExperimentalApi
public class IndexReplicationQueueEntry {

    private final Long id;

    private final Instant replicationTime;

    /**
     * Constructor with all object fields.
     *
     * @param id id of index replication operation
     * @param replicationTime sending time of operation
     */
    public IndexReplicationQueueEntry(final Long id, final Instant replicationTime) {
        this.id = id;
        this.replicationTime = replicationTime;
    }

    /**
     * Returns the ID of the index replication operation.
     *
     * @return id of operation
     */
    public Long getId() {
        return id;
    }

    /**
     * Returns time when the index replication operation was sent.
     *
     * @return sending time of operation
     */
    public Instant getReplicationTime() {
        return replicationTime;
    }
}
