package com.atlassian.jira.i18n.terminology;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import java.util.Objects;

/**
 * A base class for Terminology related events
 *
 * @since 8.16
 */
@Immutable
@ParametersAreNonnullByDefault
public abstract class AbstractTerminologyEvent {

    protected final String originalName;
    protected final String newName;
    protected final String newNamePlural;
    protected final String oldName;
    protected final String oldNamePlural;

    public AbstractTerminologyEvent(final String originalName, final String newName, final String newNamePlural, final String oldName, final String oldNamePlural) {
        this.originalName = originalName;
        this.newName = newName;
        this.newNamePlural = newNamePlural;
        this.oldName = oldName;
        this.oldNamePlural = oldNamePlural;
    }

    public String getOriginalName() {
        return originalName;
    }

    public String getNewName() {
        return newName;
    }

    public String getNewNamePlural() {
        return newNamePlural;
    }

    public String getOldName() {
        return oldName;
    }

    public String getOldNamePlural() {
        return oldNamePlural;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" +
                "originalName='" + originalName + '\'' +
                ", newName='" + newName + '\'' +
                ", newNamePlural='" + newNamePlural + '\'' +
                ", oldName='" + oldName + '\'' +
                ", oldNamePlural='" + oldNamePlural + '\'' +
                '}';
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final AbstractTerminologyEvent that = (AbstractTerminologyEvent) o;
        return Objects.equals(originalName, that.originalName) && Objects.equals(newName, that.newName)
                && Objects.equals(newNamePlural, that.newNamePlural) && Objects.equals(oldName, that.oldName)
                && Objects.equals(oldNamePlural, that.oldNamePlural);
    }

    @Override
    public int hashCode() {
        return Objects.hash(originalName, newName, newNamePlural, oldName, oldNamePlural);
    }
}
