/**
 * This package contains events related to operations performed by admin on
 * email templates:
 * <ul>
 *     <li>Email templates downloaded ({@link com.atlassian.jira.event.mail.template.EmailTemplatesDownloadedEvent})</li>
 *     <li>Email templates uploaded ({@link com.atlassian.jira.event.mail.template.EmailTemplatesUploadedEvent})</li>
 *     <li>Email templates validated ({@link com.atlassian.jira.event.mail.template.EmailTemplatesValidatedEvent})</li>
 *     <li>Email templates applied ({@link com.atlassian.jira.event.mail.template.EmailTemplatesAppliedEvent})</li>
 *     <li>Email templates reverted ({@link com.atlassian.jira.event.mail.template.EmailTemplatesRevertedEvent})</li>
 * </ul>
 * <p>
 *     Each of the events has three parameter:
 * <ul>
 *     <li><code>sessionId</code>, which should be used to correlate events in a single flow (for analytics)</li>
 *     <li><code>operationSuccessful</code>, containing information whether operation ended successfully</li>
 *     <li><code>user</code>, which is {@link com.atlassian.jira.user.ApplicationUser} performing operation. <strong>This is not used by analytics</strong></li>
 * </ul>
 * Additionally, {@link com.atlassian.jira.event.mail.template.EmailTemplatesValidatedEvent} has <code<>validationFailureReason</code>,
 * which contains the reason ({@link com.atlassian.jira.event.mail.template.EmailTemplatesValidatedEvent.ValidationFailureReason)}
 * of validation failure if operation wasn't successful. Otherwise, it's null.
 *<p>
 * Unless otherwise noted, all parameters are supposed to be used by analytics
 */

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
package com.atlassian.jira.event.mail.template;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import javax.annotation.ParametersAreNonnullByDefault;