package com.atlassian.jira.event.mail.template;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.user.ApplicationUser;

import javax.annotation.Nullable;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

@EventName("jira.administration.email.templates.validated")
public class EmailTemplatesValidatedEvent extends BaseEmailTemplatesEvent {

    @Nullable
    private final ValidationFailureReason reason;

    public EmailTemplatesValidatedEvent(final ApplicationUser user) {
        super(user, true);
        reason = null;
    }

    public EmailTemplatesValidatedEvent(final ApplicationUser user, final ValidationFailureReason reason) {
        super(user, false);
        this.reason = requireNonNull(reason);
    }

    @Nullable
    public ValidationFailureReason getValidationFailureReason() {
        return reason;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final EmailTemplatesValidatedEvent that = (EmailTemplatesValidatedEvent) o;
        return reason == that.reason;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), reason);
    }

    public enum ValidationFailureReason {
        MISSING_FILES,
        SYNTAX_ERROR,
        SENDING_ERROR
    }
}