package com.atlassian.jira.event.issuetype.screenscheme;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;

import javax.annotation.Nonnull;

/**
 * Event fired when an issue type screen scheme has been deleted
 *
 * @since v8.7
 */
@ExperimentalApi
public class IssueTypeScreenSchemeDeletedEvent extends AbstractIssueTypeScreenSchemeEvent {

    public IssueTypeScreenSchemeDeletedEvent(@Nonnull final IssueTypeScreenScheme scheme) {
        super(scheme);
    }
}
